angular.module('starter',
  [
    'ionic',
    'starter.game_controller',
    'starter.storageManagerService',
    'starter.loadGamesDataService'
  ])

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    if(window.cordova && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
      cordova.plugins.Keyboard.disableScroll(true);
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }
  });
}).config(function($stateProvider, $urlRouterProvider) {
  $stateProvider
    .state('app', {
      url: '/app',
      abstract: true,
      templateUrl: 'views/index.html'
    })
    .state('app.game', {
      url: '/game',
      views: {
        'viewContent': {
          templateUrl: 'views/game.html',
          controller: 'DefaultController'
        }
      }
    })
    .state('app.logs', {
      url: '/logs',
      views: {
        'viewContent': {
          templateUrl: 'views/logs.html',
          controller: 'LogsController'
        }
      }
    })
    .state('app.report', {
    url: '/report',
    views: {
      'viewContent': {
        templateUrl: 'views/report.html',
        controller: 'ReportController'
      }
    }
  })
    .state('app.update', {
      url: '/update',
      views: {
        'viewContent': {
          templateUrl: 'views/update.html',
          controller: 'UpdateController'
        }
      }
    })
    .state('app.reset', {
      url: '/reset',
      views: {
        'viewContent': {
          templateUrl: 'views/reset.html',
          controller: 'ResetController'
        }
      }
    })
    .state('app.help', {
      url: '/help',
      views: {
        'viewContent': {
          templateUrl: 'views/help.html',
          controller: 'HelpController'
        }
      }
    });
  $urlRouterProvider.otherwise('/app/game');
});
