angular.module('starter.gameModel', [])
.factory('gameModel', function (){
  function GameModel(gameData) {
    this.id = gameData.id;
    this.entitled = gameData.entitled;
    this.firstModel = {entitled: gameData.firstModel.entitled, answer: gameData.firstModel.answer};
    this.secondModel = {entitled: gameData.secondModel.entitled, answer: gameData.secondModel.answer};
    this.answer = 0;
    this.error = false;
  }

  GameModel.prototype.getEntitled = function () {
    return this.entitled;
  };

  GameModel.prototype.getFirstEntitled = function (){
    return this.firstModel.entitled;
  };

  GameModel.prototype.getFirstAnswer = function() {
    return this.firstModel.answer;
  };

  GameModel.prototype.setError = function (state) {
    this.error = state;
  };

  GameModel.prototype.getError = function (state) {
    return this.error;
  };

  GameModel.prototype.getId = function() {
    return this.id;
  };

  GameModel.prototype.getSecondAnswer = function() {
    return this.secondModel.answer;
  };

  GameModel.prototype.getAnswer = function() {
    return this.answer;
  };

  GameModel.prototype.setAnswer = function(answer) {
    this.answer = answer;
  };

  GameModel.prototype.getSecondEntitled = function (){
    return this.secondModel.entitled;
  };

  GameModel.build = function (raw) {
    return new GameModel(raw);
  };

  GameModel.convertToObject = function(gamesStorage) {
    var games = [];
    for (var i in gamesStorage) {
      var game = GameModel.build(gamesStorage[i]);
      if (game) {
        games.push(game);
      }
    }
    return games;
  };

  GameModel.convertOneToObject = function (game) {
    return GameModel.build(game);
  };
  return GameModel;
});
