angular.module('starter.gamesLog', ['starter.gameLogModal', 'starter.userLogsService'])
  .factory('gamesLogService', function(localStorage, gameLog, userLogs) {
    return {
      getLogs: function() {
        if (localStorage.keyExist("gamesLog")) {
          var logs = localStorage.getItem("gamesLog");
          var objects = [];
          for (var i in logs) {
            objects.push(gameLog.build({id: logs[i].gameId, answer: logs[i].answer}));
          }
          return objects;
        } else {
          return null;
        }
      },
      addToLogs: function(game) {
        if (localStorage.keyExist("gamesLog")) {
          var logs = localStorage.getItem("gamesLog");
          logs.push(gameLog.build({
            id: game.getId(),
            answer: game.getAnswer(),
            error: game.getError()}));
          localStorage.set("gamesLog", logs);
        } else {
          var objects = [];
          objects.push(gameLog.build({
            id: game.getId(),
            answer: game.getAnswer(),
            error: game.getError()}));
          localStorage.set("gamesLog", objects);
        }
      },
      unsetLogs: function() {
        if (localStorage.keyExist("gamesLog")) {
          userLogs.addUserLogs(localStorage.getItem("gamesLog"));
          localStorage.removeItem("gamesLog");
        }
      },
      isAlreadyPlayed: function(logs, gameId) {
        for (var i in logs) {
          if (logs[i].getGameId() == gameId) {
            return true;
          }
        }
        return false;
      },
      getRandomInt: function(min, max)
      {
        return (min - 1) + Math.floor(Math.random() * max + 1);
      },
      getNotPlayedGame: function(games) {
        var logs = this.getLogs();
        var newGames = [];
        for (var i in games) {
          if (!this.isAlreadyPlayed(logs, games[i].getId()))
            newGames.push(games[i]);
        }
        return newGames[this.getRandomInt(0, newGames.length)];
      }
    }
  });
