angular.module('starter.game_controller', ['starter.gameModel', 'starter.gamesLog', 'starter.gamesDataProvider', 'starter.BaTrainerProvider'])
  .controller("DefaultController", function($scope, $ionicModal, $ionicPopover, $timeout, $ionicPopup,
                                            localStorage, gameModel, loadGamesData, gamesLogService,
                                            $state, $ionicLoading, BaTrainerProvider) {
    $scope.login = {};
    if (!localStorage.keyExist("help")) {
      localStorage.set("help", "true");
      $state.go('app.help');
    }
    if (localStorage.keyExist("user")) {
      $scope.user = localStorage.getItem("user");
    }

    $scope.loginAction = function() {
      if ($scope.login.username && $scope.login.password) {
        $ionicLoading.show({ template: 'Connexion en cours...' });
        BaTrainerProvider.userLogin($scope.login, function(error, user) {
          $ionicLoading.hide();
          if (error == false) {
            if (user.message.length == 0 && user.data) {
              $scope.user = user.data;
              localStorage.set("user", $scope.user);

              if (loadGamesData.checkLastDataUpdate()){
                loadGamesData.loadData(function() {
                  if (localStorage.keyExist("gamesData")) {
                    var games = localStorage.getItem("gamesData");
                    if (games.length > 0) {
                      $scope.status = "available";
                    }
                    else {
                      $scope.status = "unavailable";
                    }
                  }
                }, $scope.user);
              } else {
                if (localStorage.keyExist("gamesData")) {
                  var games = localStorage.getItem("gamesData");
                  if (games.length > 0){
                    $scope.status = "available";
                  }
                  else {
                    $scope.status = "unavailable";
                  }
                }
              }

            } else { $scope.showAlert("Login", "Login ou mot de passe incorrect."); }
          } else { $scope.showAlert("Login", "Vérifiez votre connexion internet et essayez à nouveau."); }
        });
      } else {
        $scope.showAlert("Login", "Un champ est manquant !");
      }
    };

    $scope.status = "inwait";
    $scope.game = null;
    if (loadGamesData.checkLastDataUpdate() && $scope.user){
      loadGamesData.loadData(function() {
        if (localStorage.keyExist("gamesData")) {
          var games = localStorage.getItem("gamesData");
          if (games.length > 0) {
            $scope.status = "available";
          }
          else {
            $scope.status = "unavailable";
          }
        }
      }, $scope.user);
    } else {
      if (localStorage.keyExist("gamesData")) {
        var games = localStorage.getItem("gamesData");
        if (games.length > 0){
          $scope.status = "available";
        }
        else {
          $scope.status = "unavailable";
        }
      }
    }

    $ionicPopover.fromTemplateUrl('views/popover.html', {
      scope: $scope
    }).then(function(popover) {
      $scope.popover = popover;
    });

    $scope.getRandomInt =  function(min, max) {
      return (min - 1) + Math.floor(Math.random() * max + 1);
    };

    $scope.startRandomGame = function(oldGameInLogs) {
      if (oldGameInLogs) {
        $scope.game.setError(true);
        gamesLogService.addToLogs($scope.game);
      }
      if (localStorage.keyExist("gamesData")) {
        if ($scope.error) { $scope.error = null; }
        if ($scope.win) { $scope.win = null; }
        if (localStorage.keyExist("error")) { localStorage.removeItem("error"); }
        var games = gameModel.convertToObject(localStorage.getItem("gamesData"));
        var gamesLog = gamesLogService.getLogs();
        var currentGame = null;
        if (gamesLog && gamesLog.length > 0) {
          if (gamesLog.length < games.length) {
            currentGame = gamesLogService.getNotPlayedGame(games);
          } else {
            $scope.showAlert("Informations", "Votre score est de " + $scope.score + " / " + games.length);
            localStorage.set("score", 0);
            $scope.game = null;
            gamesLogService.unsetLogs();
            return;
          }
        } else {
          currentGame = games[this.getRandomInt(0, games.length)];
        }
        var rand = this.getRandomInt(0, 2);
        if (rand == 1) {
          var save = currentGame.firstModel;
          currentGame.firstModel = currentGame.secondModel;
          currentGame.secondModel = save;
        }
        localStorage.set("currentGame", currentGame);
        $scope.game = currentGame;
        $scope.score = localStorage.getItem("score");
      }
    };
    if (localStorage.keyExist("currentGame")) {
      $scope.game = gameModel.convertOneToObject(localStorage.getItem("currentGame"));
    }
    $scope.setAnswer = function(answer) {
      if ($scope.error) { $scope.error = null; }
      if ($scope.win) { $scope.win = null; }
      $scope.game.setAnswer(answer);
    };

    $scope.checkAnswer = function() {
      if ($scope.game) {
        var answer = $scope.game.getAnswer();

        if (answer) {
          var correct = false;
          var firstAnswer = $scope.game.getFirstAnswer();
          var secondAnswer = $scope.game.getSecondAnswer();
          switch (answer) {
            case 1:

              if (firstAnswer == "one" && secondAnswer == "multiple") {
                correct = true;
              }
              break;

            case 2:
              if (secondAnswer == "one" && firstAnswer == "multiple") {
               correct = true;
              }
              break;

            case 3:
              if (secondAnswer == "multiple" && firstAnswer == "multiple") {
                correct = true;
              }
              break;
          }
          if (correct) {
            if ($scope.game.validated == null) {
              if (!localStorage.keyExist("error")) {
                if (!localStorage.keyExist("score")) {
                  localStorage.set("score", 1);
                } else {
                  var score = localStorage.getItem("score");
                  score += 1;
                  localStorage.set("score", score);
                  $scope.score = localStorage.getItem("score");
                }
                gamesLogService.addToLogs($scope.game);
              } else {
                $scope.game.setError(true);
                gamesLogService.addToLogs($scope.game);
              }
              $scope.startRandomGame();
              //$scope.game.validated = true;

            }
          } else {
            localStorage.set("error", "true");
            $scope.showAlert("Erreur", "Votre réponse est incorrecte !");
          }
        }
        else {
          $scope.showAlert("Erreur", "Veuillez sélectionné votre réponse avant la validation !");
        }
      }
    };
    $scope.showAlert = function(title, message) {
      $ionicPopup.alert({
        title: title,
        template: message
      });
    };
    if (!localStorage.keyExist("score")) {
      localStorage.set("score", 0);
    }
    $scope.score = localStorage.getItem("score");
  })
  .controller("UpdateController", function($scope, $ionicModal, $ionicPopover, loadGamesData) {
    $scope.data = {update: "inwait"};
    $ionicPopover.fromTemplateUrl('views/popover.html', {
      scope: $scope
    }).then(function(popover) {
      $scope.popover = popover;
    });
    $scope.doUpdate = function() {
      $scope.data.update = "inwait";
      loadGamesData.loadData(function (result, gamesLength) {
        if (result) {
          if (gamesLength > 0) {
            $scope.data.update = "success";
          } else {
            $scope.data.update = "already";
          }
        } else {
          $scope.data.update = "failure";
        }
      });
    };
    loadGamesData.loadData(function (result, gamesLength) {
      if (result) {
        if (gamesLength > 0) {
          $scope.data.update = "success";
        } else {
          $scope.data.update = "already";
        }
      } else {
        $scope.data.update = "failure";
      }
    });
  })
  .controller("ResetController", function($scope, $ionicModal, $ionicPopover, localStorage, $timeout, $ionicHistory) {
    $ionicPopover.fromTemplateUrl('views/popover.html', {
      scope: $scope
    }).then(function(popover) {
      $scope.popover = popover;
    });

    $scope.deleteData = function() {
      localStorage.clear();
      $scope.game = null;
      $scope.deleted = "true";
      $ionicHistory.clearCache();
      $timeout(function() { $scope.deleted = "false"; }, 3000);
    };

  })
  .controller("HelpController", function($scope, $ionicModal, $ionicPopover, $state) {
    $ionicPopover.fromTemplateUrl('views/popover.html', {
      scope: $scope
    }).then(function(popover) {
      $scope.popover = popover;
    });

    $scope.redirectToHome = function() {
      $state.go('app.game');
    };
  })
  .controller("LogsController", function($scope, $ionicModal, $ionicPopover, userLogs, localStorage) {
    $ionicPopover.fromTemplateUrl('views/popover.html', {
      scope: $scope
    }).then(function(popover) {
      $scope.popover = popover;
    });
    $scope.getTime = function(start, time) {
      var sec_num = (time - start) / 1000;
      var days    = Math.floor(sec_num / (3600 * 24));
      var hours   = Math.floor((sec_num - (days * (3600 * 24)))/3600);
      var minutes = Math.floor((sec_num - (days * (3600 * 24)) - (hours * 3600)) / 60);
      if (minutes < 10) {minutes = "0" + minutes; }

      if (Math.round(minutes) > 0) {
        if (Math.round(minutes) > 1) {
          return Math.round(minutes) + " minutes";
        } else {
          return Math.round(minutes) + " minute";
        }
      } else {
        return " < 1 minute ";
        /*
        if (Math.round(sec_num) >= 10) {
          return "0." + Math.round(sec_num) + " secondes";
        } else {
          return "0.0" + Math.round(sec_num) + " secondes";
        }
        */
      }
    };
    $scope.reloadData = function() {
      var logs = userLogs.getUserLogs();
      if (logs.length > 0) {
        logs = logs.reverse();
        var result = [];
        var score = 0;
        var size = localStorage.getItem("gamesData").length;
        var startTime = 0;
        var endTime = 0;
        for (var i in logs)
        {
          for (var q in logs[i]) {
            if (startTime == 0) { startTime = logs[i][q].startTime; }
            if (endTime == 0) { endTime = logs[i][q].endTime; }
            if (logs[i][q].error == false &&
              logs[i][q].answer > 0) {
              score++;
            }
          }
          var startPrint = new Date((startTime / 1000) * 1000).toLocaleString("fr-FR",
            {month: "long", day: "numeric", hour: "numeric", minute: "numeric"});
          var endPrint = new Date((endTime / 1000) * 1000).toLocaleString("fr-FR",
            {month: "long", day: "numeric", hour: "numeric", minute: "numeric"});
          result.push({score: score, length: size, start: startPrint, end: endPrint,
          elapsed: this.getTime(startTime, endTime)});
          score = 0;
          startTime = 0;
          endTime = 0;
        }
        $scope.logs = result;
      }
    };
    $scope.clearLogs = function() {
      if (localStorage.keyExist("userLogs")) {
        localStorage.removeItem("userLogs");
      }
      $scope.logs = null;
    };
});
