angular.module('starter.gameLogModal', [])
  .factory('gameLog', function () {
    function GameLog(log) {
        this.gameId = log.id;
        this.answer = log.answer;
        this.error = log.error;
        this.startTime = new Date().getTime();
    }

    GameLog.prototype.getGameId = function() {
      return this.gameId;
    };

    GameLog.prototype.getStartTime = function() {
      return this.startTime;
    };

    GameLog.prototype.getAnswer = function () {
      return this.answer;
    };

    GameLog.build = function (raw) {
      return new GameLog(raw);
    };

    GameLog.convertOneToObject = function (game) {
      return GameLog.build(game);
    };

    return GameLog;
  });
