angular.module('starter.loadGamesDataService', ['starter.gamesDataProvider'])
  .factory('loadGamesData', function(localStorage, gamesDataProvider) {
    return {
      getTime: function(time, start) {
        var sec_num = (time - start) / 1000;
        var days    = Math.floor(sec_num / (3600 * 24));
        var hours   = Math.floor((sec_num - (days * (3600 * 24)))/3600);
        var minutes = Math.floor((sec_num - (days * (3600 * 24)) - (hours * 3600)) / 60);
        if (minutes < 10) {minutes = "0" + minutes; }

        return Math.round(minutes);
      },
      checkLastDataUpdate: function() {
        var date = localStorage.getItem("lastUpdate");
        if (date && date > 0) {
          var minutesElapsed = this.getTime(new Date().getTime(), date);
          if (localStorage.getItem("lastUpdateFailed")) {
            return (minutesElapsed >= 5);
          } else {
            return (minutesElapsed >= 30);
          }
        } else {
          return true;
        }
      },
      setLastUpdateFailed: function() {
        localStorage.set("lastUpdateFailed", "true");
      },
      removeLastUpdateFailed: function() {
        if (localStorage.keyExist("lastUpdateFailed")) {
          localStorage.removeItem("lastUpdateFailed");
        }
      },
      isAlreadyLoaded: function(gameId) {
        if (localStorage.keyExist("gamesData")) {
          var games = localStorage.getItem("gamesData");
          for (var game in games) {
            if (parseInt(games[game].id) == parseInt(gameId)) {
              return true;
            }
          }
          return false;
        } else {
          return false;
        }
      },
      loadData: function(callback, user) {
        if (!localStorage.keyExist("user") && user == null) {
          return;
        }
        var self = this;
        localStorage.set("lastUpdate", new Date().getTime());
        gamesDataProvider.getAllGamesData(function(error, data) {
          if (error == false) {
            if (data) {
              var games = [];
              for (var game in data) {
                if (!self.isAlreadyLoaded(data[game].id)) {
                  games.push(data[game]);
                }
              }
              if (games.length > 0) {
                var newGames = localStorage.getItem("gamesData");
                if (!newGames) {
                  newGames = [];
                }
                for (var g in games) {
                  newGames.push(games[g]);
                }
                localStorage.set("gamesData", newGames);
              }
              self.removeLastUpdateFailed();
              if (callback) callback(true, games.length);
            }
            else {
             self.setLastUpdateFailed();
              if (callback) callback(false);
            }
          }
          else {
            self.setLastUpdateFailed();
            if (callback) callback(false);
          }
        }, (localStorage.keyExist("user")) ? localStorage.getItem("user") : user);
      }
    }
  });
