angular.module('starter.storageManagerService', ['LocalStorageModule'])
  .factory('localStorage', function(localStorageService) {
    return {
      getItem: function(value) {
        return localStorageService.get(value);
      },
      removeItem: function(key) {
        localStorageService.remove(key);
      },
      set: function(key, value, type){
        localStorageService.set(key, value, type);
      },
      keyExist: function(key) {
        return (localStorageService.get(key) != null);
      },
      clearStorage: function() {
        localStorageService.clearAll();
      },
      getLength: function () {
        return localStorageService.length;
      },
      canSetCookie: function() {
        return localStorageService.cookie.isSupported;
      },
      getType: function() {
        return localStorageService.getStorageType();
      },
      clear: function () {
        localStorageService.clearAll();
      }
    }
  });
